﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Inet.Viewer.Data;
using Inet.Viewer.WinForms.Prompt;
using NUnit.Framework;

namespace Inet.Viewer.test.WinForms
{
    [TestFixture]
    class TestPromptDialogForm
    {
        [Test]
        public void TestShowsCorrectPanel()
        {
            PromptData p1 = new PromptData(
                "prompt", null, "desc", new string[] { "a", "b" },
                new string[] { "desca", "descb" },
                PromptData.String, true, false, false, true, false,
                false, null, null, null);
            PromptData p2 = new PromptData(
                "prompt2", null, "desc", new string[] { }, new string[] { }, PromptData.Number,
                true, false, false, true, false,
                false, null, null, null);

            List<PromptData> prompts = new List<PromptData>();
            prompts.Add(p1);
            prompts.Add(p2);
            PromptDialogForm d = new PromptDialogForm(prompts, new PromptPanelBuilder(),false);
            d.Show();
            Control c = d.panel.Controls[0];
            Assert.IsInstanceOf<SinglePromptFieldWithDefaultValues>(c);
        }

        [Test]
        public void TestRemembersValue()
        {
            PromptData p1 = new PromptData(
                "prompt", null, "desc", new string[] { "a", "b" },
                new string[] { "desca", "descb" },
                PromptData.String, true, false, false, true, false,
                false, null, null, null);
            PromptData p2 = new PromptData(
                "prompt2", null, "desc", new string[] { }, new string[] { }, PromptData.Number,
                true, false, false, true, false,
                false, null, null, null);
            List<PromptData> prompts = new List<PromptData>();
            prompts.Add(p1);
            prompts.Add(p2);
            PromptDialogForm d = new PromptDialogForm(prompts, new PromptPanelBuilder(),false);
            d.Show();
            ((SinglePromptFieldWithDefaultValues)d.panel.Controls[0]).cmbDefaultValues.SelectedItem = null;
            ((SinglePromptFieldWithDefaultValues)d.panel.Controls[0]).cmbDefaultValues.Text = "ABC";
            d.promptTree.SelectedNode = d.AllNodes[d.AllNodes.IndexOf(d.promptTree.SelectedNode) + 1];
            Assert.AreEqual("'ABC'", prompts[0].Values.StringRepresentation);

            ((SinglePromptField)d.panel.Controls[0]).txtValueBox.Text = "47";
            d.promptTree.SelectedNode = d.AllNodes[d.AllNodes.IndexOf(d.promptTree.SelectedNode) - 1];
            Assert.AreEqual("ABC", ((SinglePromptFieldWithDefaultValues)d.panel.Controls[0]).cmbDefaultValues.Text);
            Assert.AreEqual("47", prompts[1].Values.StringRepresentation);

            d.promptTree.SelectedNode = d.AllNodes[d.AllNodes.IndexOf(d.promptTree.SelectedNode) + 1];
            Assert.AreEqual("47", ((SinglePromptField)d.panel.Controls[0]).txtValueBox.Text);
            Assert.AreEqual("'ABC'", prompts[0].Values.StringRepresentation);

            ((SinglePromptField)d.panel.Controls[0]).txtValueBox.Text = "";
            d.promptTree.SelectedNode = d.AllNodes[d.AllNodes.IndexOf(d.promptTree.SelectedNode) - 1];
            ((SinglePromptFieldWithDefaultValues)d.panel.Controls[0]).chkNoValue.Checked = true;
            d.promptTree.SelectedNode = d.AllNodes[d.AllNodes.IndexOf(d.promptTree.SelectedNode) + 1];
            Assert.AreEqual("", prompts[0].Values.StringRepresentation);
            Assert.AreEqual("", prompts[1].Values.StringRepresentation);

            d.promptTree.SelectedNode = d.AllNodes[d.AllNodes.IndexOf(d.promptTree.SelectedNode) - 1];
            Assert.IsTrue(((SinglePromptFieldWithDefaultValues)d.panel.Controls[0]).chkNoValue.Checked);
        }

        [Test]
        public void TestRangeValueInPromptList()
        {
            PromptData p1 = new PromptData("rangePrompt", null, null,
                new string[] { }, new string[] { }, PromptData.String, false, true,
                false, true, false, false, null, null, null);
            PromptData p2 = new PromptData(
    "prompt2", null, "desc", new string[] { }, new string[] { }, PromptData.Number,
    true, false, false, true, false,
    false, null, null, null);
            List<PromptData> prompts = new List<PromptData>();
            prompts.Add(p1);
            prompts.Add(p2);
            PromptDialogForm d = new PromptDialogForm(prompts, new PromptPanelBuilder(),false);
            d.Show();
            ((RangePromptField)d.panel.Controls[0]).txtValueBoxFrom.Text = "A";
            ((RangePromptField)d.panel.Controls[0]).txtValueBoxTo.Text = "B";
            ((RangePromptField)d.panel.Controls[0]).chkIncludeFrom.Checked = true;
            ((RangePromptField)d.panel.Controls[0]).chkIncludeTo.Checked = true;
            d.promptTree.SelectedNode = d.AllNodes[d.AllNodes.IndexOf(d.promptTree.SelectedNode) + 1];
            Assert.AreEqual("'A' to 'B'", prompts[0].Values.StringRepresentation);
            d.promptTree.SelectedNode = d.AllNodes[d.AllNodes.IndexOf(d.promptTree.SelectedNode) - 1];
            RangePromptField f = d.panel.Controls[0] as RangePromptField;
            Assert.AreEqual("A", f.txtValueBoxFrom.Text);
            Assert.AreEqual("B", f.txtValueBoxTo.Text);
            Assert.IsTrue(f.chkIncludeFrom.Checked);
            Assert.IsTrue(f.chkIncludeTo.Checked);
        }
        [Test]
        public void TestValidates()
        {
            PromptData p1 = new PromptData(
                "prompt", null, "desc", new string[] { }, new string[] { }, PromptData.Currency, true, false, false, true, false,
                false, null, null, "47");
            PromptData p2 = new PromptData(
                "prompt2", null, "desc", new string[] { }, new string[] { }, PromptData.Currency, true, false, false, true, false,
                false, null, null, "47");
            List<PromptData> prompts = new List<PromptData>();
            prompts.Add(p1);
            prompts.Add(p2);
            PromptDialogForm d = new PromptDialogForm(prompts, new PromptPanelBuilder(),false);
            d.Show();
            ((SinglePromptField)d.panel.Controls[0]).txtValueBox.Text = "48";
            d.promptTree.SelectedNode = d.AllNodes[d.AllNodes.IndexOf(d.promptTree.SelectedNode) + 1];
            Assert.AreEqual(0, d.AllNodes.IndexOf(d.promptTree.SelectedNode));
            ((SinglePromptField)d.panel.Controls[0]).txtValueBox.Text = "47";
            d.promptTree.SelectedNode = d.AllNodes[d.AllNodes.IndexOf(d.promptTree.SelectedNode) + 1];
            Assert.AreEqual(1, d.AllNodes.IndexOf(d.promptTree.SelectedNode));
            ((SinglePromptField)d.panel.Controls[0]).txtValueBox.Text = "48";
            d.promptTree.SelectedNode = d.AllNodes[d.AllNodes.IndexOf(d.promptTree.SelectedNode) - 1];
            Assert.AreEqual(1, d.AllNodes.IndexOf(d.promptTree.SelectedNode));
            ((SinglePromptField)d.panel.Controls[0]).txtValueBox.Text = "46";
            d.promptTree.SelectedNode = d.AllNodes[d.AllNodes.IndexOf(d.promptTree.SelectedNode) - 1];
            Assert.AreEqual(0, d.AllNodes.IndexOf(d.promptTree.SelectedNode));
            Assert.AreEqual("47", ((SinglePromptField)d.panel.Controls[0]).txtValueBox.Text);
            d.promptTree.SelectedNode = d.AllNodes[d.AllNodes.IndexOf(d.promptTree.SelectedNode) + 1];
            Assert.AreEqual("46", ((SinglePromptField)d.panel.Controls[0]).txtValueBox.Text);
        }
    }
}
